/*
 *  linux/arch/arm/mach-uniphier/core.h
 *
 *  Copyright (C) 2011 Panasonic Corporation
 *  - Derived from arch/arm/mach-realview/core.h
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ASM_ARCH_CORE_H
#define __ASM_ARCH_CORE_H

#include <linux/io.h>

#include <asm/setup.h>
#include <asm/leds.h>
#include <mach/powerdomain.h>

struct machine_desc;

extern void __iomem *gic_cpu_base_addr;

extern int is_reserved_bootloader_memory(void);
extern void free_bootloader_memory(void);

#ifdef CONFIG_PM
extern unsigned int raw_get_ibmode(void);
extern void reload_ibmode(void);
#else /* CONFIG_PM */
static inline unsigned int raw_get_ibmode(void)
{
	return IBMODE_NORMAL;
}

static inline void reload_ibmode(void)
{
}
#endif /* CONFIG_PM */

//#if defined(CONFIG_SMP) && defined(CONFIG_PM)
#if defined(CONFIG_PM)
extern int uniphier_enter_lowpower(unsigned int cpu, unsigned int power_state);
extern int uniphier_finish_suspend(unsigned long cpu_state);
extern void uniphier_cpu_resume(void);
extern int unphier_hotplug_cpu(unsigned int cpu, unsigned int power_state);
#else /* CONFIG_SMP && CONFIG_PM */
static inline int uniphier_enter_lowpower(unsigned int cpu,
					unsigned int power_state)
{
	cpu_do_idle();
	return 0;
}

static inline int uniphier_hotplug_cpu(unsigned int cpu, unsigned int power_state)
{
	cpu_do_idle();
	return 0;
}

static inline int uniphier_finish_suspend(unsigned long cpu_state)
{
	return 0;
}

static inline void uniphier_cpu_resume(void)
{}

#endif /* CONFIG_SMP && CONFIG_PM */

#endif
